package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaOS2CustomDao;
import com.ejie.ab04b.dao.custom.TareaTramiteOS2CustomDao;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaOS2ServiceImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Service(value = "tareaOS2Service")
public class TareaOS2ServiceImpl implements TareaOS2Service {

	@Autowired()
	private TareaOS2CustomDao tareaOS2Dao;
	@Autowired()
	private TareaTramiteOS2CustomDao tareaTramiteOs2Dao;

	/**
	 * Inserts a single row in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @return the tarea OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS2 add(TareaOS2 tareaOS2) {
		return this.tareaOS2Dao.add(tareaOS2);
	}

	/**
	 * Updates a single row in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @return the tarea OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS2 update(TareaOS2 tareaOS2) {
		return this.tareaOS2Dao.update(tareaOS2);
	}

	/**
	 * Updates a single row in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @return the tarea OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS2 updateFilled(TareaOS2 tareaOS2) {
		return this.tareaOS2Dao.updateFilled(tareaOS2);
	}

	/**
	 * Finds a single row in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @return the tarea OS 2
	 */
	public TareaOS2 find(TareaOS2 tareaOS2) {
		return this.tareaOS2Dao.vfind(tareaOS2);
	}

	/**
	 * Finds a single row in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @return the tarea OS 2
	 */
	public TareaOS2 findTareaTramite(TareaOS2 tareaOS2) {
		return this.tareaTramiteOs2Dao.vfind(tareaOS2);
	}

	/**
	 * Finds a single row in the TareaOS2 table.
	 * 
	 *  mailboxTaskId
	 *            String
	 *  TareaOS2
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea OS 2
	 */
	public TareaOS2 findByMailboxTaskId(String mailboxTaskId) {
		return this.tareaOS2Dao.findByMailboxTaskId(mailboxTaskId);
	}

	/**
	 * Deletes a single row in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *
	 * @param tareaOS2 the tarea OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TareaOS2 tareaOS2) {
		this.tareaOS2Dao.remove(tareaOS2);
	}

	/**
	 * Finds a list of rows in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS2>
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaOS2> findAll(TareaOS2 tareaOS2,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TareaOS2>) this.tareaOS2Dao.vfindAll(tareaOS2,
				jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the TareaOS2 table.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS2>
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaOS2> findAllTareatramite(TareaOS2 tareaOS2,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TareaOS2>) this.tareaTramiteOs2Dao.vfindAll(tareaOS2,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the TareaOS2 table using like.
	 * 
	 *  tareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TareaOS2>
	 *
	 * @param tareaOS2 the tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TareaOS2> findAllLike(TareaOS2 tareaOS2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TareaOS2>) this.tareaOS2Dao.findAllLike(tareaOS2,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TareaOS2 table.
	 * 
	 *  filterTareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TareaOS2>
	 *
	 * @param filterTareaOS2 the filter tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TareaOS2> filter(TareaOS2 filterTareaOS2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TareaOS2> listaTareaOS2 = this.tareaOS2Dao
				.findAllLike(filterTareaOS2, jqGridRequestDto, false);
		Long recordNum = this.tareaOS2Dao.findAllLikeCount(
				filterTareaOS2 != null ? filterTareaOS2 : new TareaOS2(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TareaOS2>> reorderSelection = this.tareaOS2Dao
					.reorderSelection(filterTareaOS2, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TareaOS2>(jqGridRequestDto, recordNum,
					listaTareaOS2, reorderSelection);
		}
		return new JQGridResponseDto<TareaOS2>(jqGridRequestDto, recordNum,
				listaTareaOS2);
	}

	/**
	 * Searches rows in the TareaOS2 table.
	 * 
	 *  filterTareaOS2
	 *            TareaOS2
	 *  searchTareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS2>>
	 *
	 * @param filterTareaOS2 the filter tarea OS 2
	 * @param searchTareaOS2 the search tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TareaOS2>> search(TareaOS2 filterTareaOS2,
			TareaOS2 searchTareaOS2, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.tareaOS2Dao.search(filterTareaOS2, searchTareaOS2,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TareaOS2 table.
	 * 
	 *  filterTareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTareaOS2 the filter tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TareaOS2 filterTareaOS2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tareaOS2Dao.reorderSelection(filterTareaOS2,
				jqGridRequestDto, startsWith);
	}

}
